<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;
    protected $fillable = array('client_id', 'sum_value', 'statut', 'date', 'currency');
    protected $visible = array('client_id', 'sum_value', 'statut', 'date', 'currency');

    public function clients()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function invoiceJobs()
    {
        return $this->hasMany('App\Models\Invoicejob');
    }

}